{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:13:51 $                                        =}
{========================================================================}
unit fmMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, StdCtrls, MMMixer, MMDesign, MMObj, MMSlider, MMMixCtl,
  MMPanel, MMMixBlk, MMDIBCv, MMLevel, MMCmpMan, MMHook, MMDevice;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Parameters1: TMenuItem;
    Properties1: TMenuItem;
    AddPropsItem: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    N2: TMenuItem;
    About1: TMenuItem;
    Bevel1: TBevel;
    MMDesigner1: TMMDesigner;
    Panel2: TPanel;
    MixerControl: TMMMixerControl;
    DestLine: TMMAudioLine;
    MMMixerLabelConnector1: TMMMixerLabelConnector;
    MMCompManager1: TMMCompManager;
    SamplePanel: TPanel;
    Panel3: TPanel;
    AddPanel: TPanel;
    Button2: TButton;
    MMMixerBlock1: TMMMixerBlock;
    MMMixerBlockLevel2: TMMMixerBlockLevel;
    MMMixerBlockLabel4: TMMMixerBlockLabel;
    MMMixerBlockLabel5: TMMMixerBlockLabel;
    MMMixerBlockLabel6: TMMMixerBlockLabel;
    MMMixerBlockSlider3: TMMMixerBlockSlider;
    MMMixerBlockSlider4: TMMMixerBlockSlider;
    MMMixerBlockCheck2: TMMMixerBlockCheck;
    Bevel2: TBevel;
    Bevel3: TBevel;
    MixerDevice1: TMMMixerDevice;
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Properties1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AddPropsItemClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    FCloned     : TList;
    FAddProps   : Boolean;
    FOrigHeight : Integer;

    function    CreateLineControls(LineId: TMMLineId; MixerIndex: Integer; PrevW : Integer ) : Integer ;
    procedure   ClearLineControls;
    procedure   UpdateLineControls;
    procedure   ShowAddItems;
    procedure   SetHeight;
    procedure   CreateParams(var Params: TCreateParams); override;
  public
  end;

var
  MainForm: TMainForm;

implementation

uses fmProps, Clipbrd, MMAbout, fmAdd;

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Exit1Click(Sender: TObject);
begin
   Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.About1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Properties1Click(Sender: TObject);
begin
   if PropertiesForm.Execute then
      UpdateLineControls;
end;

{-- TMainForm -----------------------------------------------------------}
function TMainForm.CreateLineControls( LineId : TMMLineId; MixerIndex : Integer; PrevW : Integer ) : Integer ;
var
   Block            : TMMMixerBlock;
   PanelOuter, Panel: TPanel;
begin
   if PropertiesForm.IsSelected(MixerIndex) then
   begin
      PanelOuter              := MMCompManager1.CloneComponent(SamplePanel) as TPanel;
      Panel                   := PanelOuter.Controls[1] as TPanel;
      Block                   := Panel.Controls[1] as TMMMixerBlock;
      FCloned.Add(Panel);
      Block.Line              := TMMAudioLine.Create(Self);
      FCloned.Add(Block.Line);
      FCloned.Add(PanelOuter);
      Block.Line.Mixer        := MixerDevice1;
      Block.Line.LineId       := LineId;

      if (MixerIndex <> 0) and (MixerControl.Available) then
          Block.Mixer         := MixerControl;

      if MixerIndex = 0 then
           (Block.Mute as TMMMixerBlockCheck).Caption := '&Mute all'
      else if Block.MuteKind = mkSelect then
           (Block.Mute as TMMMixerBlockCheck).Caption  := '&Select'
      else
           (Block.Mute as TMMMixerBlockCheck).Caption  := '&Mute';

      PanelOuter.Visible  := True;
      PanelOuter.TabOrder := 0;

      if AddPropsForm.HasProps(LineId) then
      begin
         AddPropsItem.Visible := True;
         FAddProps := True;
      end;

      Result := PrevW + PanelOuter.Left + PanelOuter.Width;
   end
   else
      Result := PrevW;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.ShowAddItems;
var
    i      : Integer;
    Panel  : TPanel;
    Panel2 : TPanel;
    Button : TButton;
    Line   : TMMAudioLine;
begin
   for i := 0 to FCloned.Count div 3 - 1 do
   begin
      Panel           := TPanel(FCloned[3*i]);
      Line            := TMMAudioLine(FCloned[3*i+1]);
      Panel2          := Panel.Controls[0] as TPanel;
      Button          := Panel2.Controls[0] as TButton;
      Panel2.Visible  := True;
      Button.Visible  := AddPropsForm.HasProps(Line.LineId);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.ClearLineControls;
var
   i: Integer;
begin
   LockWindowUpdate(Handle);
   try
      for i := 0 to FCloned.Count - 1 do
      begin
         TComponent(FCloned[i]).Free;
      end;
   finally
      LockWindowUpdate(0);
   end;
   FCloned.Clear;
   FAddProps := False;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
   FOrigHeight := Height - AddPanel.Height;
   UpdateLineControls;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.UpdateLineControls;
var
   Lines : TList;
   i     : Integer;
   W     : Integer;
begin
   AddPropsItem.Checked := PropertiesForm.ShowAdditional;
   ClearLineControls;
   DestLine.LineId := PropertiesForm.GetCurrentDestination;
   MixerControl.ControlType := ctMixer;

   if not MixerControl.Available then
      MixerControl.ControlType := ctMux;

   Caption := DestLine.LineInfo.Name;
   Application.Title := Caption;

   Lines := TList.Create;
   try
      PropertiesForm.GetCurrentLines(Lines);
      W := 0;
      LockWindowUpdate(Handle);
      try
         for i := Lines.Count - 1 downto 0 do
             W := CreateLineControls(TMMLineId(Lines[i]),i,W);

         ClientWidth  := W - 2 ; { Do not show bevel }
         if FAddProps and AddPropsItem.Checked then
            ShowAddItems;
         AddPropsItem.Enabled := FAddProps;
         SetHeight;

      finally
         LockWindowUpdate(0);
      end;
   finally
      Lines.Free;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   FCloned := TList.Create;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormDestroy(Sender: TObject);
begin
   FCloned.Free;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.AddPropsItemClick(Sender: TObject);
begin
   PropertiesForm.ShowAdditional := not AddPropsItem.Checked;
   UpdateLineControls;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Button1Click(Sender: TObject);
begin
   AddPropsForm.ShowProps(((Sender as TButton).Parent.Parent.Controls[1] as TMMMixerBlock ).Line.LineId);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.SetHeight;
begin
   if FAddProps and AddPropsItem.Checked then
      Height := FOrigHeight + AddPanel.Height
   else
      Height := FOrigHeight;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.CreateParams(var Params: TCreateParams);
begin
   inherited CreateParams(Params);
   Params.Style := Params.Style and not WS_SIZEBOX;
end;

end.
